/*
 * Decompiled with CFR 0.152.
 */
package net.dragon81655.dragoncommands.networking.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.dragon81655.dragoncommands.claims.ClaimClass;
import net.dragon81655.dragoncommands.claims.ClaimRegister;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClaimDataS2CPacket {
    private final List<ClaimClass> myList;

    public ClaimDataS2CPacket(List<ClaimClass> list) {
        this.myList = list;
    }

    public static void encode(ClaimDataS2CPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.myList.size());
        for (ClaimClass item : packet.myList) {
            item.toPacketBuffer(buffer);
        }
    }

    public static ClaimDataS2CPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<ClaimClass> list = new ArrayList<ClaimClass>();
        for (int i = 0; i < size; ++i) {
            list.add(ClaimClass.fromPacketBuffer(buffer));
        }
        return new ClaimDataS2CPacket(list);
    }

    public static void handle(ClaimDataS2CPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            List<ClaimClass> receivedList = packet.myList;
            ClaimRegister.claimData = receivedList;
        });
        context.setPacketHandled(true);
    }
}

