/*
 * Decompiled with CFR 0.152.
 */
package net.dragon81655.dragoncommands.claims;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.mojang.math.Vector3d;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Scanner;
import net.dragon81655.dragoncommands.DragonCommands;
import net.dragon81655.dragoncommands.claims.ClaimClass;
import net.dragon81655.dragoncommands.gson.GsonSimplifier;
import net.dragon81655.dragoncommands.networking.ModMessages;
import net.dragon81655.dragoncommands.networking.packet.ClaimDataS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ClaimRegister {
    public static final String path = "claims.json";
    public static List<ClaimClass> claimData;

    public static void RegisterNewClaim(Vector3d coords1, Vector3d coords2, Player player) {
        String owner = player.m_5446_().getString();
        ClaimClass claimClass = new ClaimClass();
        claimClass.owner = owner;
        claimClass.bX = coords1.f_86214_ > coords2.f_86214_ ? coords1.f_86214_ : coords2.f_86214_;
        claimClass.sX = coords1.f_86214_ < coords2.f_86214_ ? coords1.f_86214_ : coords2.f_86214_;
        claimClass.bZ = coords1.f_86216_ > coords2.f_86216_ ? coords1.f_86216_ : coords2.f_86216_;
        claimClass.sZ = coords1.f_86216_ < coords2.f_86216_ ? coords1.f_86216_ : coords2.f_86216_;
        claimClass.claimName = player.m_5446_().getString() + "Claim";
        String t = ClaimRegister.CanClaim(claimClass);
        if (!t.equals("Success")) {
            player.m_6352_((Component)new TextComponent(t), player.m_142081_());
            return;
        }
        claimData.add(claimClass);
        GsonSimplifier.ToJson(claimData, path);
        if (player instanceof ServerPlayer) {
            ModMessages.sendToAllPlayers(new ClaimDataS2CPacket(claimData));
        }
    }

    private static String CanClaim(ClaimClass currentClaim) {
        if ((currentClaim.bX - currentClaim.sX) * (currentClaim.bZ - currentClaim.sZ) > (double)DragonCommands.serverProperties.sizeOfCountry) {
            return "Area too big: " + ((currentClaim.bX - currentClaim.sX) * (currentClaim.bZ - currentClaim.sZ) - (double)DragonCommands.serverProperties.sizeOfCountry) + " excessive blocks!";
        }
        if (claimData == null) {
            return "Success";
        }
        if (claimData.size() == 0) {
            return "Success";
        }
        for (int i = 0; i < claimData.size(); ++i) {
            if (!ClaimRegister.claimData.get((int)i).owner.equals(currentClaim.owner)) continue;
            return "You already own a claim";
        }
        ClaimClass overlapedClaim = new ClaimClass();
        for (ClaimClass claim : claimData) {
            if (currentClaim.sX > claim.bX || currentClaim.bX < claim.sX) {
                return "Success";
            }
            if (currentClaim.sZ > claim.bZ || currentClaim.bZ < claim.sZ) {
                return "Success";
            }
            overlapedClaim = claim;
        }
        return "Your claim overlaps with " + overlapedClaim.owner + ". The smallest X coordinate = " + overlapedClaim.sX + " The smallest Z coordinate = " + overlapedClaim.sZ + " Biggest X = " + overlapedClaim.bX + "Biggest Z = " + overlapedClaim.bZ + ". If your biggest is smaller then one of the smallest or one of your smallest is bigger then one of the biggest then you won't overlap.";
    }

    public static void SaveClaimData() {
        GsonSimplifier.ToJson(claimData, path);
    }

    public static void DeleteClaim(Player player) {
        String owner = player.m_5446_().getString();
        if (claimData.size() == 0) {
            player.m_6352_((Component)new TextComponent("You do not own a claim!"), player.m_142081_());
            return;
        }
        for (int i = 0; i < claimData.size(); ++i) {
            ClaimClass c = claimData.get(i);
            if (!c.owner.equals(owner)) continue;
            claimData.remove(c);
            GsonSimplifier.ToJson(claimData, path);
            if (player instanceof ServerPlayer) {
                ModMessages.sendToAllPlayers(new ClaimDataS2CPacket(claimData));
            }
            player.m_6352_((Component)new TextComponent("Claim deleted successfully!"), player.m_142081_());
        }
        player.m_6352_((Component)new TextComponent("You do not own a claim!"), player.m_142081_());
    }

    public static List<LinkedTreeMap> FromJson(String path) {
        Object fromJson = "";
        try {
            File myObj = new File(path);
            if (myObj.exists()) {
                Scanner myReader = new Scanner(myObj);
                while (myReader.hasNextLine()) {
                    String data = myReader.nextLine();
                    fromJson = (String)fromJson + data;
                }
                myReader.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("No file found");
            e.printStackTrace();
        }
        if (!((String)fromJson).equals("")) {
            return (List)new Gson().fromJson((String)fromJson, new TypeToken<List<LinkedTreeMap>>(){}.getType());
        }
        return null;
    }

    public static boolean CheckIfIsClaimOwner(Player player, BlockPos pos) {
        for (int i = 0; i < claimData.size(); ++i) {
            String name;
            ClaimClass currentClaim = claimData.get(i);
            if (!((double)pos.m_123341_() >= currentClaim.sX) || !((double)pos.m_123341_() <= currentClaim.bX) || !((double)pos.m_123343_() >= currentClaim.sZ) || !((double)pos.m_123343_() <= currentClaim.bZ) || (name = player.m_5446_().getString()).equals(currentClaim.owner)) continue;
            for (String s : currentClaim.allies) {
                if (!s.equals(name)) continue;
                return false;
            }
            for (String s : currentClaim.enemyKingdom) {
                ClaimClass enemyKingdom = null;
                for (ClaimClass c : claimData) {
                    if (!c.claimName.equals(s)) continue;
                    enemyKingdom = c;
                    break;
                }
                if (enemyKingdom == null) continue;
                if (name.equals(enemyKingdom.owner)) {
                    return false;
                }
                for (String a : enemyKingdom.allies) {
                    if (!name.equals(a)) continue;
                    return false;
                }
            }
            player.m_6352_((Component)new TextComponent("You are not trusted in " + currentClaim.claimName + " property of king " + currentClaim.owner), player.m_142081_());
            return currentClaim.unbreakable;
        }
        return false;
    }
}

