/*
 * Decompiled with CFR 0.152.
 */
package net.dragon81655.dragoncommands;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.dragon81655.dragoncommands.block.ModBlocks;
import net.dragon81655.dragoncommands.block.entity.ModBlockEntities;
import net.dragon81655.dragoncommands.claims.ClaimClass;
import net.dragon81655.dragoncommands.claims.ClaimRegister;
import net.dragon81655.dragoncommands.gson.GsonSimplifier;
import net.dragon81655.dragoncommands.item.ModItems;
import net.dragon81655.dragoncommands.networking.ModMessages;
import net.dragon81655.dragoncommands.screen.BankScreen;
import net.dragon81655.dragoncommands.screen.ModMenuTypes;
import net.dragon81655.dragoncommands.screen.PlayerShopBuyScreen;
import net.dragon81655.dragoncommands.screen.PlayerShopScreen;
import net.dragon81655.dragoncommands.serverproperties.PropertiesClass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="dragoncommands")
public class DragonCommands {
    public static PropertiesClass serverProperties;
    public static final String MODID = "dragoncommands";
    private static final String path = "dragoncommandsProperties.json";
    private static final Logger LOGGER;

    public DragonCommands() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModMessages.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Starting server, reading dragonCommands properties.");
        serverProperties = new PropertiesClass();
        Object fromJson = "";
        try {
            File myObj = new File(path);
            if (myObj.exists()) {
                Scanner myReader = new Scanner(myObj);
                while (myReader.hasNextLine()) {
                    String data = myReader.nextLine();
                    fromJson = (String)fromJson + data;
                }
                myReader.close();
            }
            serverProperties = (PropertiesClass)new Gson().fromJson((String)fromJson, serverProperties.getClass());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (((String)fromJson).equals("")) {
            try {
                serverProperties = new PropertiesClass();
                FileWriter file = new FileWriter(path, false);
                file.write(new Gson().toJson((Object)serverProperties));
                file.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        List<LinkedTreeMap> temp = GsonSimplifier.FromJson("claims.json");
        ClaimRegister.claimData = new ArrayList<ClaimClass>();
        if (temp != null) {
            for (LinkedTreeMap l : temp) {
                ClaimRegister.claimData.add(new ClaimClass(l));
            }
            if (ClaimRegister.claimData == null) {
                ClaimRegister.claimData = new ArrayList<ClaimClass>();
            }
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    @Mod.EventBusSubscriber(modid="dragoncommands", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            ItemStack pS = new ItemStack((ItemLike)ModItems.PRESIDENT_STAFF.get());
            pS.m_41784_().m_128379_("showingClaims", false);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PLAYER_SHOP_MENU.get()), PlayerShopScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PLAYER_SHOP_BUY_MENU.get()), PlayerShopBuyScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BANK_MENU.get()), BankScreen::new);
        }
    }
}

