using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class QStateController : MonoBehaviour
{

    public string CalculateNewState(float health, float stamina, bool defensiveStance, bool beingAttacked)
    {
        char[] newStatus = { 'c', 'c', 'c', 'c' };
        if (health >= 60)
        {
            newStatus[0] = 'H';
        }
        else if (health >= 20 && health < 60)
        {
            newStatus[0] = 'M';
        }
        else if (health < 20)
        {
            newStatus[0] = 'L';
        }

        if (stamina >= 60)
        {
            newStatus[1] = 'H';
        }
        else if (stamina >= 20 && stamina < 60)
        {
            newStatus[1] = 'M';
        }
        else if (stamina < 20)
        {
            newStatus[1] = 'L';
        }

        newStatus[2] = defensiveStance ? 'D' : 'A';
        newStatus[3] = beingAttacked ? 'A' : 'O';

        return new string(newStatus);
    }

}
