using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

public delegate string QSimulationCallBack(string state, int action, int iteration);
public class QL_Manager : MonoBehaviour

{
    // Start is called before the first frame update
    [Header("Q-Learning config")]
    public string ql_table_path; //= "q_table.json";
    [SerializeField] private string ql_rewards_path; //= "q_rewards.json";
    public float baseDiscount;
    public float learnRate; //To implement
    public float epsilon;
    public int maxIterations;

    private QL_Function ql_function;
    private QL_Policy ql_policy;
    private QL_Table ql_table;


    void Awake()
    {
        ql_table_path = System.IO.Path.Combine(Application.persistentDataPath, ql_table_path);
        ql_table = new QL_Table();
        //ql_table.ExportTable(ql_table_path);
        ql_table.PopulateTable(ql_table_path);
        ql_policy= new QL_Policy();
        ql_function= new QL_Function();
        ql_function.Init(ql_table, ql_policy,this, baseDiscount,maxIterations);
        ql_policy.Init(ql_table, epsilon, ql_function);
    }

    public QLActions RequestBestAction(string currentState, QSimulationCallBack simulator)
    {
        return ql_function.ChooseAction(currentState, simulator);
    }

    public void UpdateQTable(string currentState, int action, float reward)
    {
        float newReward = (1-learnRate) * ql_table.GetReward(currentState, action) + reward * learnRate;
        ql_table.UpdateQTable(currentState, action, newReward);
    }

    public void ExportTable()
    {
        ql_table.ExportTable(ql_table_path);
    }

    public void PopulateTable()
    {
        ql_table.PopulateTable(ql_table_path);
    }

    public void Init()
    {
        ql_function.Init(ql_table, ql_policy, this, baseDiscount, maxIterations);
        ql_policy.Init(ql_table, epsilon, ql_function);
    }
}
[Serializable]
public enum QLActions
{
    Wait = 0,
    Light_Attack,
    Heavy_Attack,
    Dodge,
    Parry,
    ChangeStance_D,
    ChangeStance_A
}